%% Ackley Function 
% Ackley is a multi-modal function with many local optima. This function is
% difficult because optimization algorithms can easily be trapped in a
% local minimum on its way to the global minimizer.
%
% * It is multi-modal function
% * Minima : [0, 0, ..., 0]
% * Maxima : 22.35040
% * Maximum Dimensionality : 30
%% 
% *Function definition* 
%
% $$f(<x_i>) = 20+e-20e^{-0.2\sqrt{\frac{\sum_{i=1}^n x_i^2}{n}}} - e^\frac{{\sum_{i=1}^n}\cos 2\pi x_i}{n}$$
%%
% *3D plot*
    clc; clear; figure
    x = -3:0.1:3; y = -3:0.1:3;
    xy=zeros(length(x)*length(y),2);
    cntpts=0;
    for ii=1:length(x)
        for jj=1:length(y)
            cntpts=cntpts+1;
            xy(cntpts,1:2)=[x(ii),y(jj)];
        end
    end
    funval = Ackley([xy]);
    funval = reshape(funval, length(y), length(x));
    surfc(x, y, funval)
    xlabel('X'); ylabel('Y'); zlabel('Z');
%%
% *Other Useful Functions*
% 
% <DeJong>  <Rosenbrock> <Ackley> <Alpine> <Rastrigin>  <Griewank> <Schaffer>
%